//This is the main function. Here the image is processed, filtered, and labelling of different objects is done. The vehicle number is displayed in a message box.
clc;
clear;
getimage=uigetfile("*.jpg","*.png"); //prompts the user to select the image file(rgb)
 numberplate=' '; //initializes variable for storing characters of number plate
vehicleimage=imread(getimage); //reads the image selected by the user   

grayimage=rgb2gray(vehicleimage); // converts the rgb image to gray-scale image
    
z=1; //initializes variable to be used in getletter and getnumber function  

exec('getletter.sci'); //executes the getletter function
exec('getnumber.sci'); //executes the getnumber function


//reads the templates of alphabets and numbers to be used in template matching 

A=imread('A.bmp');B=imread('B.bmp'); 

C=imread('C.bmp');D=imread('D.bmp');
E=imread('E.bmp');F=imread('F.bmp');
G=imread('G.bmp');H=imread('H.bmp');
I=imread('I.bmp');J=imread('J.bmp');
K=imread('K.bmp');L=imread('L.bmp');
M=imread('M.bmp');N=imread('N.bmp');
O=imread('O.bmp');P=imread('P.bmp');
Q=imread('Q.bmp');R=imread('R.bmp');
S=imread('S.bmp');T=imread('T.bmp');
U=imread('U.bmp');V=imread('V.bmp');
W=imread('W.bmp');X=imread('X.bmp');
Y=imread('Y.bmp');Z=imread('Z.bmp');
M1=imread('M17.bmp');M2=imread('M22.bmp');
M3=imread('M24.bmp');M4=imread('M29.bmp');
M5=imread('M4.bmp');M5=imread('M8.bmp');M6=imread('M19.bmp');
K1=imread('K25.bmp');K2=imread('K27.bmp');K3=imread('K28.bmp');


one=imread('1.bmp');  two=imread('2.bmp');
three=imread('3.bmp');four=imread('4.bmp');
five=imread('5.bmp'); six=imread('6.bmp');
seven=imread('7.bmp');eight=imread('8.bmp');
nine=imread('9.bmp'); zero=imread('0.bmp');
onevar=imread('1var.bmp');


//will store all the templates of alphabets
//will store all the templates of numbers
//they are declared global so as to be accessible by getletter and getnumber function

 global letter  
 global number 




letter=cat(3,A, B,   C, D ,  E, F, G, H, I, J, K, L ,M, N, O,  P,   Q ,  R ,  S, T, U, V, W, X, Y, Z,M1,M2,M3,M4,M5,M6,K1,K2,K3); //concatenates the 2-d arrays of template images according to 3rd dimension

number=cat(3,one ,two, three, four,  five, six,   seven, eight,  nine ,  zero,onevar ); //concatenates the 2-d arrays of template images according to 3rd dimension
    // The template images can be imagined as stacked on top of one another.

    fil1=fspecial('average',3); //creates a mean filter mask of dimension 3*3
    filteredimage1=imfilter(grayimage,fil1); //applies the mean filter on the gray image to remove noise from the image
    
    edgedetected=edge(filteredimage1,'canny',[0.7 0.9]); //outlines or detecs the edges of the  filtered image by canny edge method with lower threshold value of 0.7 and upper threshold value of 0.9
    
    se=imcreatese('ellipse',2,2); //creates a structure(matrix) of ellipse shape using 0 and 1 values. The matrix has dimensions  2*2 
    dilatedimage=imdilate(edgedetected,se); //performs dilation on the edge detected image to spread the white pixels
    
    blackandwhite1=im2bw(dilatedimage,0.6); //converts the dilated image to binary image using a threshold value of 0.6
    
    filledimage=imfill(blackandwhite1); //this function fills the holes in the binarized image.This results in getting the number plate as a white rectangular object against a black background.
   
    se2=imcreatese('ellipse',1,1); // creates a structure(matrix) of ellipse shape using 0 and 1 values.        The matrix has dimensions  1*1     
erodedimage=imerode(filledimage,se2);//performs erosion on the binary image to spread around the black pixels of the background
    
    integerimage=bool2s(erodedimage); //converts the binary image of Boolean data type to binary image of integer data type(0 and1)

    finalimage=integerimage.*grayimage; //this multiplies the binary image containing the white number plate(having value 1) and the black background(having value 0) with the grayscale image to get the number on the white plate 
    
    fil2=fspecial('average',3); //create a mean filter of dimension 3*3
    filteredimage2=imfilter(finalimage,fil2); //filters the image with the mean filter
    
    blackandwhite2=im2bw(filteredimage2,0.6); //thresholding to remove features other than the plate 
    
    complementimage=imcomplement(blackandwhite2); //converts the black to white and vice versa.
  
    
    [labelledimage numberofobjects]=imlabel(complementimage); //labels the different objects (characters) in the image and stores the number in numberofobjects 
   
  [area boundingbox]=imblobprop(labelledimage); //draws rectangular boxes around  all the labelled objects and stores the areas in area variable  and the properties of bounding boxes in bounding box variable

    sortedarea=gsort(area); //sorts the all the areas of bounding boxes and stores In sortedarea variable
   
    
  
   
   [newboundingbox arrangedorder]=unique(boundingbox,"c"); //sorts the bounding boxes according to first row ie x-cordinates of the bounding boxes

  imshow(vehicleimage);//shows the original image
    x=1; // initializes the variable for detecting letters at appropriate positions

    [sortedarearows sortedareacolumns]=size(sortedarea); //finds the number of bounding boxes formed

    //this takes only the first 10 or 11 largest bounding boxes which contains the characters and ignores the other smaller bounding boxes

   for i=1:numberofobjects //goes through all bounding boxes 

       flag=1; //flag variable 

       if sortedareacolumns==10
       for j=1:10
           if area(arrangedorder(1,i))==sortedarea(1,j)
               flag=2; 
       end
   end
else 
    for j=1:11
           if area(arrangedorder(1,i))==sortedarea(1,j)
               flag=2; 
       end
   end
   end
   
   if flag==2
      
      if newboundingbox(3,i)<=150  & newboundingbox(4,i)>7  //for filtering out very big and very small bounding boxes
        croppedimage=imcrop(complementimage,[newboundingbox(1,i),newboundingbox(2,i),newboundingbox(3,i),newboundingbox(4,i)]); //crops the character
 
croppedimage=imresize(croppedimage,[42,24]); //resizes the cropped character image to be of the same size as that of template images
       
        
        
        if x==1 | x==2 | x==5 | x==6 // for detecting letters which are in the 1st , 2nd,3rd and 5th position in the number plate
            numberplate=strcat([numberplate,getletter(croppedimage,x)]); //call getletter function to get the matching alphabet
        else
            numberplate=strcat([numberplate,getnumber(croppedimage)]); //calls the get number function to get the matching number
        end 
        
        x=x+1;
        
    end
end
end

[btn] = messagebox(numberplate,"Vehicle Number","info"); //displays the character in a message box
